import { useState, useEffect } from "react";
import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { Navbar } from "@/components/Navbar";
import { Footer } from "@/components/Footer";
import { AnimatePresence } from "framer-motion";
import { VideoLoadingScreen } from "@/components/VideoLoadingScreen";

// Pages
import Home from "@/pages/Home";
import About from "@/pages/About";
import Services from "@/pages/Services";
import Work from "@/pages/Work";
import CaseStudy from "@/pages/CaseStudy";
import A1inc2 from "@/pages/A1inc2";
import Contact from "@/pages/Contact";
import Legal from "@/pages/Legal";
import NotFound from "@/pages/not-found";

import { Signature } from "@/components/Signature";

function Router() {
  return (
    <AnimatePresence mode="wait">
      <Switch>
        <Route path="/" component={Home} />
        <Route path="/about" component={About} />
        <Route path="/services" component={Services} />
        <Route path="/work" component={Work} />
        <Route path="/work/:slug" component={CaseStudy} />
        <Route path="/a1inc-2" component={A1inc2} />
        <Route path="/contact" component={Contact} />
        <Route path="/legal/:type" component={Legal} />
        <Route component={NotFound} />
      </Switch>
    </AnimatePresence>
  );
}

function App() {
  const [showLoading, setShowLoading] = useState(false);

  useEffect(() => {
    const hasSeenIntro = sessionStorage.getItem("hasSeenIntro");
    if (!hasSeenIntro) {
      setShowLoading(true);
      sessionStorage.setItem("hasSeenIntro", "true");
    }
  }, []);

  return (
    <QueryClientProvider client={queryClient}>
      <AnimatePresence>
        {showLoading && (
          <VideoLoadingScreen key="loading" onFinished={() => setShowLoading(false)} />
        )}
      </AnimatePresence>
      <div className="min-h-screen flex flex-col font-sans bg-background text-foreground">
        <Navbar />
        <main className="flex-grow">
          <Router />
        </main>
        <Footer />
        <Signature />
        <Toaster />
      </div>
    </QueryClientProvider>
  );
}

export default App;
