import { Link } from "wouter";

export function Footer() {
  return (
    <footer className="relative border-t border-white/5 bg-black/20 pt-20 pb-10">
      <div className="max-w-7xl mx-auto px-6">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-12 mb-16">
          <div className="space-y-4">
            <h3 className="font-display text-2xl font-bold">A1INC</h3>
            <p className="text-white/40 text-sm max-w-[200px]">
              Engineering premium digital outcomes for ambitious brands.
            </p>
          </div>

          <div>
            <h4 className="font-medium mb-6 text-white/80">Company</h4>
            <ul className="space-y-4 text-sm text-white/40">
              <li><Link href="/about" className="hover:text-white transition-colors">About</Link></li>
              <li><Link href="/work" className="hover:text-white transition-colors">Work</Link></li>
              <li><Link href="/contact" className="hover:text-white transition-colors">Contact</Link></li>
            </ul>
          </div>

          <div>
            <h4 className="font-medium mb-6 text-white/80">Services</h4>
            <ul className="space-y-4 text-sm text-white/40">
              <li><Link href="/services" className="hover:text-white transition-colors">Brand Identity</Link></li>
              <li><Link href="/services" className="hover:text-white transition-colors">Web Engineering</Link></li>
              <li><Link href="/services" className="hover:text-white transition-colors">Product Design</Link></li>
            </ul>
          </div>

          <div>
            <h4 className="font-medium mb-6 text-white/80">Connect</h4>
            <ul className="space-y-4 text-sm text-white/40">
              <li><a href="https://x.com/a1m4sxd" className="hover:text-white transition-colors">Twitter / X</a></li>
              <li><a href="https://www.linkedin.com/company/a1inc/" className="hover:text-white transition-colors">LinkedIn</a></li>
              <li><a href="https://www.instagram.com/a1inc.site/" className="hover:text-white transition-colors">Instagram</a></li>
            </ul>
          </div>
        </div>

        <div className="pt-8 border-t border-white/5 flex flex-col md:flex-row justify-between items-center gap-4 text-xs text-white/20">
          <p>© 2024 A1INC. All rights reserved.</p>
          <div className="flex gap-6">
            <Link href="/legal/privacy" className="hover:text-white transition-colors">Privacy Policy</Link>
            <Link href="/legal/terms" className="hover:text-white transition-colors">Terms of Service</Link>
          </div>
        </div>
      </div>
    </footer>
  );
}
