import { cn } from "@/lib/utils";
import { motion, HTMLMotionProps } from "framer-motion";

interface GlassCardProps extends HTMLMotionProps<"div"> {
  variant?: 1 | 2 | 3;
}

export function GlassCard({ children, className, variant = 2, ...props }: GlassCardProps) {
  const variants = {
    1: "glass-1",
    2: "glass-2",
    3: "glass-3",
  };

  return (
    <motion.div 
      className={cn(
        "rounded-2xl p-6 transition-colors duration-300", 
        variants[variant],
        className
      )}
      {...props}
    >
      {children}
    </motion.div>
  );
}
