import { useEffect, useRef, useState } from "react";

export function Signature() {
  const containerRef = useRef<HTMLDivElement>(null);
  const [position, setPosition] = useState({ x: 50, y: 50 });

  useEffect(() => {
    const handleMouseMove = (e: MouseEvent) => {
      if (!containerRef.current) return;
      const rect = containerRef.current.getBoundingClientRect();
      const x = ((e.clientX - rect.left) / rect.width) * 100;
      const y = ((e.clientY - rect.top) / rect.height) * 100;
      setPosition({ x, y });
    };

    const container = containerRef.current;
    if (container) {
      container.addEventListener("mousemove", handleMouseMove);
    }

    return () => {
      if (container) {
        container.removeEventListener("mousemove", handleMouseMove);
      }
    };
  }, []);

  return (
    <div 
      ref={containerRef}
      className="w-full bg-[#0a0a0a] py-8 transition-all duration-500 overflow-hidden"
    >
      <div className="h-[20rem] flex items-center justify-center">
        <div className="w-full max-w-4xl scale-75 md:scale-100">
          <svg 
            width="100%" 
            height="100%" 
            viewBox="0 0 300 100" 
            xmlns="http://www.w3.org/2000/svg" 
            className="select-none"
          >
            <defs>
              <linearGradient id="textGradient" gradientUnits="userSpaceOnUse" cx="50%" cy="50%" r="25%">
                <stop offset="0%" stopColor="white" />
                <stop offset="100%" stopColor="white" />
              </linearGradient>
              <radialGradient 
                id="revealMask" 
                gradientUnits="userSpaceOnUse" 
                r="20%" 
                cx={`${position.x}%`} 
                cy={`${position.y}%`}
              >
                <stop offset="0%" stopColor="white"></stop>
                <stop offset="100%" stopColor="black"></stop>
              </radialGradient>
              <mask id="textMask">
                <rect x="0" y="0" width="100%" height="100%" fill="url(#revealMask)"></rect>
              </mask>
            </defs>
            <text 
              x="50%" 
              y="50%" 
              textAnchor="middle" 
              dominantBaseline="middle" 
              strokeWidth="0.3" 
              className="font-[helvetica] font-bold stroke-neutral-200 dark:stroke-neutral-800 fill-transparent text-7xl" 
              style={{ opacity: 0 }}
            >
              
            </text>
            <text 
              x="50%" 
              y="50%" 
              textAnchor="middle" 
              dominantBaseline="middle" 
              strokeWidth="0.3" 
              className="font-[helvetica] font-bold fill-transparent text-7xl stroke-neutral-200 dark:stroke-neutral-800" 
              strokeDashoffset="0" 
              strokeDasharray="1000"
            >
              
            </text>
            <text 
              x="50%" 
              y="50%" 
              textAnchor="middle" 
              dominantBaseline="middle" 
              stroke="url(#textGradient)" 
              strokeWidth="0.3" 
              mask="url(#textMask)" 
              className="font-[helvetica] font-bold fill-transparent text-7xl"
            >
              A1INC
            </text>
          </svg>
        </div>
      </div>
    </div>
  );
}
