import { useState, useEffect } from "react";
import introVideo from "@assets/Minimalist_Brand_Identity_Reveal_Video_1770373388818.mp4";
import { motion } from "framer-motion";

export function VideoLoadingScreen({ onFinished }: { onFinished: () => void }) {
  const [isVisible, setIsVisible] = useState(true);

  const handleVideoEnd = () => {
    setIsVisible(false);
  };

  const handleVideoError = () => {
    console.error("Video failed to load or play");
    setIsVisible(false);
  };

  useEffect(() => {
    // Safety timeout in case video fails to play
    const timeout = setTimeout(() => {
      if (isVisible) {
        setIsVisible(false);
      }
    }, 8000); 

    return () => clearTimeout(timeout);
  }, [isVisible]);

  return (
    <motion.div
      initial={{ opacity: 1 }}
      animate={{ opacity: isVisible ? 1 : 0 }}
      exit={{ opacity: 0 }}
      transition={{ duration: 1.5, ease: "easeInOut" }}
      onAnimationComplete={() => {
        if (!isVisible) {
          onFinished();
        }
      }}
      className="fixed inset-0 z-[9999] bg-black flex items-center justify-center overflow-hidden pointer-events-none"
    >
      <video
        autoPlay
        muted
        playsInline
        onEnded={handleVideoEnd}
        onError={handleVideoError}
        className="absolute w-full h-full object-cover"
      >
        <source src={introVideo} type="video/mp4" />
      </video>
    </motion.div>
  );
}
