import { PageTransition } from "@/components/PageTransition";
import { motion } from "framer-motion";

export default function A1inc2() {
  return (
    <PageTransition>
      <div className="h-screen flex flex-col items-center justify-center relative overflow-hidden bg-black">
        {/* Background Effects */}
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_center,_var(--tw-gradient-stops))] from-purple-900/20 via-black to-black" />
        <div className="absolute inset-0 opacity-20" style={{ backgroundImage: "url('data:image/svg+xml,...')" }} /> {/* Noise */}

        <motion.div
          initial={{ opacity: 0, scale: 0.9 }}
          animate={{ opacity: 1, scale: 1 }}
          transition={{ duration: 1 }}
          className="relative z-10 text-center px-6"
        >
          <h1 className="text-[15vw] leading-none font-display font-bold text-transparent bg-clip-text bg-gradient-to-b from-white to-purple-900/50 mix-blend-overlay">
            2.0
          </h1>
          <p className="text-2xl md:text-4xl font-light tracking-[1em] text-white/60 mt-8 uppercase">
            Coming Soon
          </p>
          
          <div className="mt-16 inline-block border border-white/10 bg-white/5 backdrop-blur-md px-8 py-4 rounded-full text-sm font-mono text-white/40">
            Evolution Imminent
          </div>
        </motion.div>
      </div>
    </PageTransition>
  );
}
