import { PageTransition } from "@/components/PageTransition";
import { GlassCard } from "@/components/GlassCard";
import { motion } from "framer-motion";

import almasPhoto from "@assets/Almas_1770368303905.jpg";
import asrafPhoto from "@assets/image_1770370941289.png";
import tokirPhoto from "@assets/tokir photo.png";
import piyushPhoto from "@assets/piyush photo.jpg";
import arshPhoto from "@assets/arsh photo.jpg";
import saadPhoto from "@assets/saad photo.png";

export default function About() {
  const team = [
    { name: "Almas Khan", role: "Chief Executive Officer", bio: "Visionary leader steering A1INC’s strategic direction, innovation, and global expansion with unwavering commitment to excellence.", chips: ["Strategy", "Vision", "Leadership"], photo: almasPhoto },
    { name: "Asraf Khan", role: "Chief Operations Officer", bio: "Ensures seamless operations, optimal team performance, and efficient execution of all initiatives.", chips: ["Operations", "Performance", "Execution"], photo: asrafPhoto },
    { name: "Tokir Khan", role: "Chief Financial Officer", bio: "Manages finances, budgets, and investments with precision to ensure long-term sustainable growth.", chips: ["Finance", "Investment", "Growth"], photo: tokirPhoto },
    { name: "Piyush Gupta", role: "Chief Technology Officer", bio: "Architect of cutting-edge solutions, driving innovation and technical excellence across platforms.", chips: ["Tech Architecture", "Innovation", "Engineering"], photo: piyushPhoto },
    { name: "Arsh Shaikh", role: "Creative Director", bio: "Leads creative vision, brand identity, and design strategy for peak aesthetic and strategic impact.", chips: ["Design", "Branding", "Creative"], photo: arshPhoto },
    { name: "Saad Shaikh", role: "Managing Director", bio: "Oversees business development, client relationships, and strategic growth for market leadership.", chips: ["B-Dev", "Growth", "Relations"], photo: saadPhoto }
  ];

  return (
    <PageTransition>
      <div className="max-w-7xl mx-auto px-6 py-20">
        {/* Header */}
        <div className="max-w-3xl mb-32">
          <h1 className="text-5xl md:text-7xl font-display font-bold mb-8">
            Obsessed with <span className="text-white/40">Perfection.</span>
          </h1>
          <p className="text-xl text-white/70 leading-relaxed">
            A1INC was founded on a simple premise: Digital experiences should be treated as high-precision engineering projects, not just artistic endeavors. We combine the discipline of software architecture with the soul of creative design.
          </p>
        </div>

        {/* The Problem */}
        <div className="mb-32">
          <h2 className="text-2xl font-display mb-12 flex items-center gap-4">
            <span className="w-12 h-[1px] bg-white/20"></span>
            The Problem Space
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            {[
              { title: "Generic Brands", desc: "Market saturation means safe designs disappear into the noise." },
              { title: "Slow Performance", desc: "Bloated sites kill conversion rates and damage SEO rankings." },
              { title: "Fragmented UX", desc: "Disconnected systems create friction for users and admins alike." }
            ].map((item, i) => (
              <GlassCard key={i} variant={3} className="border-t border-white/20 rounded-none bg-transparent px-0 py-8">
                <span className="text-xs font-mono text-white/30 mb-4 block">0{i+1}</span>
                <h3 className="text-xl font-bold mb-3">{item.title}</h3>
                <p className="text-white/50 text-sm leading-relaxed">{item.desc}</p>
              </GlassCard>
            ))}
          </div>
        </div>

        {/* What We Do */}
        <div className="mb-32">
          <h2 className="text-2xl font-display mb-12 flex items-center gap-4">
            <span className="w-12 h-[1px] bg-white/20"></span>
            Our Solution
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <GlassCard className="md:col-span-2 p-12">
              <h3 className="text-3xl font-bold mb-4">Integrated Systems</h3>
              <p className="text-white/60 max-w-2xl">
                We don't just build websites; we build ecosystems. From your brand identity to your deployment pipeline, every component is designed to work in concert.
              </p>
            </GlassCard>
            <GlassCard className="h-64 flex flex-col justify-between">
              <h3 className="text-xl font-bold text-white/80">Rapid Iteration</h3>
              <div className="w-full h-1 bg-white/10 rounded-full overflow-hidden">
                <div className="w-2/3 h-full bg-white/40" />
              </div>
            </GlassCard>
            <GlassCard className="h-64 flex flex-col justify-between bg-white/5">
              <h3 className="text-xl font-bold text-white/80">Data Driven</h3>
              <div className="flex gap-1 items-end h-12">
                <div className="w-4 h-4 bg-white/20" />
                <div className="w-4 h-8 bg-white/30" />
                <div className="w-4 h-6 bg-white/20" />
                <div className="w-4 h-10 bg-white/50" />
              </div>
            </GlassCard>
          </div>
        </div>

        {/* Team Section */}
        <div className="mb-32">
          <h2 className="text-2xl font-display mb-12 flex items-center gap-4">
            <span className="w-12 h-[1px] bg-white/20"></span>
            Leadership Team
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {team.map((member, i) => (
              <GlassCard key={i} className="group overflow-hidden flex flex-col p-6">
                <div className="aspect-square rounded-xl overflow-hidden mb-6 relative">
                   <img src={member.photo} alt={member.name} className="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500" />
                   <div className="absolute inset-0 bg-black/20" />
                </div>
                <h3 className="text-xl font-bold mb-1">{member.name}</h3>
                <p className="text-sm font-mono text-white/40 mb-4 uppercase tracking-wider">{member.role}</p>
                <p className="text-sm text-white/60 mb-6 leading-relaxed flex-grow">{member.bio}</p>
                <div className="flex flex-wrap gap-2">
                  {member.chips.map(chip => (
                    <span key={chip} className="text-[10px] uppercase tracking-widest px-2 py-0.5 rounded border border-white/10 text-white/30">
                      {chip}
                    </span>
                  ))}
                </div>
              </GlassCard>
            ))}
          </div>
        </div>

        {/* Expansion Blocks */}
        <div className="space-y-32">
          <div>
            <h2 className="text-2xl font-display mb-12 flex items-center gap-4">
              <span className="w-12 h-[1px] bg-white/20"></span>
              Strategic Philosophy
            </h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <GlassCard className="p-8">
                <h3 className="text-xl font-bold mb-4">Architecture First</h3>
                <p className="text-white/50 leading-relaxed">
                  We believe that great design is useless without a rock-solid foundation. Every pixel we place is backed by logic that ensures speed, accessibility, and scalability for years to come.
                </p>
              </GlassCard>
              <GlassCard className="p-8 bg-white/5">
                <h3 className="text-xl font-bold mb-4">Precision Branding</h3>
                <p className="text-white/50 leading-relaxed">
                  A brand is more than a logo. It is a promise. We engineer visual identities that resonate with authority and clarity across every possible medium.
                </p>
              </GlassCard>
            </div>
          </div>
        </div>
      </div>
    </PageTransition>
  );
}
