import { PageTransition } from "@/components/PageTransition";
import { GlassCard } from "@/components/GlassCard";
import { useRoute } from "wouter";

export default function Legal() {
  const [match, params] = useRoute("/legal/:type");
  const type = params?.type;

  const title = type === 'privacy' ? 'Privacy Policy' : 'Terms of Service';

  return (
    <PageTransition>
      <div className="max-w-4xl mx-auto px-6 py-20">
        <h1 className="text-4xl font-display font-bold mb-8">{title}</h1>
        <GlassCard className="p-8 md:p-12 bg-white/5 border-white/10">
          <div className="prose prose-invert prose-white max-w-none">
            <p>Last updated: October 2023</p>
            <h3>1. Introduction</h3>
            <p>Welcome to A1INC. By accessing our website, you agree to these terms.</p>
            
            <h3>2. Intellectual Property</h3>
            <p>The content, organization, graphics, design, compilation, magnetic translation, digital conversion and other matters related to the Site are protected under applicable copyrights, trademarks and other proprietary (including but not limited to intellectual property) rights.</p>
            
            <h3>3. Use of Services</h3>
            <p>We provide digital engineering services. Clients receive rights to deliverables upon full payment.</p>
            
            {/* Placeholder legal text */}
            <h3>4. Limitation of Liability</h3>
            <p>In no event will A1INC be liable for any incidental, consequential, or indirect damages.</p>
          </div>
        </GlassCard>
      </div>
    </PageTransition>
  );
}
