import { PageTransition } from "@/components/PageTransition";
import { useCaseStudies } from "@/hooks/use-a1inc";
import { GlassCard } from "@/components/GlassCard";
import { Link } from "wouter";
import { Loader2 } from "lucide-react";
import { useState } from "react";
import { cn } from "@/lib/utils";

export default function Work() {
  const { data: caseStudies, isLoading } = useCaseStudies();
  const [filter, setFilter] = useState("All");

  const categories = ["All", "Branding", "UI/UX", "Development", "Motion"];

  const filteredWork = filter === "All" 
    ? caseStudies 
    : caseStudies?.filter(cs => cs.category.includes(filter) || cs.tags.includes(filter));

  return (
    <PageTransition>
      <div className="max-w-7xl mx-auto px-6 py-20">
        <h1 className="text-5xl md:text-8xl font-display font-bold mb-12">Selected Work</h1>
        
        {/* Filters */}
        <div className="flex flex-wrap gap-2 mb-16">
          {categories.map(cat => (
            <button
              key={cat}
              onClick={() => setFilter(cat)}
              className={cn(
                "px-6 py-2 rounded-full text-sm font-medium transition-all duration-300 border border-transparent",
                filter === cat 
                  ? "bg-white text-black" 
                  : "bg-white/5 text-white/60 hover:bg-white/10 hover:text-white border-white/5"
              )}
            >
              {cat}
            </button>
          ))}
        </div>

        {/* Grid */}
        {isLoading ? (
          <div className="flex justify-center py-20">
            <Loader2 className="animate-spin w-8 h-8 text-white/20" />
          </div>
        ) : (
          <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
            {filteredWork?.map((study) => (
              <Link key={study.id} href={`/work/${study.slug}`}>
                <GlassCard className="group p-0 overflow-hidden cursor-pointer h-full border-0 bg-transparent">
                  {/* Image Container */}
                  <div className="relative aspect-video overflow-hidden rounded-2xl mb-6">
                    <div className="absolute inset-0 bg-black/20 group-hover:bg-transparent transition-colors z-10" />
                    {/* Unsplash placeholder with descriptive comment */}
                    {/* Tech abstract imagery for project thumbnails */}
                    <img 
                      src={study.thumbnail} 
                      alt={study.title}
                      className="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-700"
                    />
                  </div>
                  
                  {/* Content */}
                  <div className="px-2">
                    <div className="flex flex-wrap gap-2 mb-3">
                      {study.tags.slice(0, 3).map(tag => (
                        <span key={tag} className="text-xs uppercase tracking-wider px-2 py-1 rounded border border-white/10 text-white/50">
                          {tag}
                        </span>
                      ))}
                    </div>
                    <h3 className="text-2xl font-bold group-hover:text-white/80 transition-colors">{study.title}</h3>
                    <p className="text-white/50 mt-2 line-clamp-2">{study.summary}</p>
                  </div>
                </GlassCard>
              </Link>
            ))}
          </div>
        )}
      </div>
    </PageTransition>
  );
}
