import { Link } from "wouter";
import { GlassCard } from "@/components/GlassCard";
import { AlertCircle } from "lucide-react";

export default function NotFound() {
  return (
    <div className="min-h-screen w-full flex items-center justify-center bg-background px-4">
      <GlassCard className="max-w-md w-full text-center p-8 bg-black/40 border-white/10">
        <div className="flex justify-center mb-6">
          <AlertCircle className="h-16 w-16 text-red-500 opacity-80" />
        </div>
        <h1 className="text-4xl font-bold font-display mb-4 text-white">404</h1>
        <p className="text-white/60 mb-8">
          The page you are looking for has been moved, deleted, or possibly never existed in this timeline.
        </p>
        <Link href="/">
          <a className="inline-block bg-white text-black font-semibold px-6 py-3 rounded-full hover:bg-white/90 transition-colors">
            Return Home
          </a>
        </Link>
      </GlassCard>
    </div>
  );
}
