# A1INC - Premium Digital Agency Website

## Overview

A1INC is a multi-page portfolio/agency website for a digital engineering studio. It showcases the company's work (case studies), services, about page, contact form, and a "coming soon" page for A1INC 2.0. The site features a dark, premium aesthetic with glassmorphism effects, smooth animations, and a modern tech stack. It's a full-stack application with a React frontend, Express backend, and PostgreSQL database.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend
- **Framework**: React 18 with TypeScript, using Vite as the build tool
- **Routing**: Client-side routing via `wouter` (lightweight alternative to React Router). Routes include `/`, `/about`, `/services`, `/work`, `/work/:slug`, `/a1inc-2`, `/contact`, `/legal/:type`
- **Styling**: Tailwind CSS with CSS variables for theming. Dark-mode-first design with custom glass morphism utilities (`glass-1`, `glass-2`, `glass-3` classes). Fonts: Inter (body) and Outfit (headings) via Google Fonts
- **UI Components**: shadcn/ui component library (new-york style) with Radix UI primitives. Components live in `client/src/components/ui/`
- **Animations**: Framer Motion for page transitions (`PageTransition` component with `AnimatePresence`), scroll reveals, navbar animations, and interactive elements
- **State Management**: TanStack React Query for server state. Custom hooks in `client/src/hooks/use-a1inc.ts` wrap all API calls
- **Forms**: React Hook Form with Zod resolver for the contact form, validated against shared schemas
- **Path aliases**: `@/` maps to `client/src/`, `@shared/` maps to `shared/`

### Backend
- **Framework**: Express 5 running on Node.js with TypeScript (executed via `tsx`)
- **API Design**: RESTful JSON API. Routes defined in `server/routes.ts`, API contract defined in `shared/routes.ts`
- **API Endpoints**:
  - `GET /api/work` — List all case studies
  - `GET /api/work/:slug` — Get a single case study by slug
  - `GET /api/services` — List all services
  - `POST /api/contact` — Submit a contact form
- **Storage Layer**: `server/storage.ts` defines an `IStorage` interface with a `DatabaseStorage` implementation using Drizzle ORM. This abstraction makes it possible to swap storage backends
- **Dev Server**: Vite middleware is integrated into Express during development for HMR. In production, the built static files are served from `dist/public/`
- **Build**: Custom build script (`script/build.ts`) uses Vite for frontend and esbuild for backend bundling. Output goes to `dist/`

### Shared Code
- **Schema** (`shared/schema.ts`): Drizzle ORM table definitions and Zod validation schemas shared between frontend and backend
  - `caseStudies` — Portfolio work items with slug, title, summary, tech stack (text array), content (JSONB), thumbnail, hero image, tags, and category
  - `contactSubmissions` — Contact form entries with name, email, company, budget, message
  - `services` — Service offerings with title, description, icon name, and category
- **Routes Contract** (`shared/routes.ts`): Centralized API path and response type definitions used by both server route handlers and client query hooks

### Database
- **Database**: PostgreSQL via `node-postgres` (`pg` package)
- **ORM**: Drizzle ORM with `drizzle-zod` for automatic Zod schema generation from table definitions
- **Migrations**: Drizzle Kit configured in `drizzle.config.ts`. Use `npm run db:push` to push schema changes
- **Connection**: Requires `DATABASE_URL` environment variable. Connection pool created in `server/db.ts`

### Key Design Patterns
- **Shared types**: Database schemas and API contracts are defined once in `shared/` and used by both client and server, ensuring type safety across the stack
- **Glass morphism UI**: Custom CSS classes (`glass-1`, `glass-2`, `glass-3`) defined in `index.css` provide consistent glassmorphism styling throughout
- **Page transitions**: All pages are wrapped in a `PageTransition` component with Framer Motion's `AnimatePresence` for smooth enter/exit animations
- **Sticky glass navbar**: Floating pill-shaped navbar with backdrop blur, animated route indicator using Framer Motion's `layoutId`

## External Dependencies

### Database
- **PostgreSQL**: Required. Connection string provided via `DATABASE_URL` environment variable. Used with Drizzle ORM and `connect-pg-simple` for session storage

### Key NPM Packages
- **drizzle-orm** + **drizzle-kit**: ORM and migration tooling for PostgreSQL
- **express** (v5): HTTP server framework
- **@tanstack/react-query**: Server state management on the client
- **framer-motion**: Animation library for React
- **shadcn/ui** + **@radix-ui/***: Accessible UI component primitives
- **tailwindcss**: Utility-first CSS framework
- **zod**: Runtime type validation (shared between client and server)
- **react-hook-form** + **@hookform/resolvers**: Form handling with Zod validation
- **wouter**: Lightweight client-side routing
- **lucide-react**: Icon library

### Fonts (External)
- Google Fonts: Inter, Outfit, DM Sans, Fira Code, League Spartan, Architects Daughter (loaded via `<link>` tags in `index.html` and `@import` in CSS)

### Replit-Specific
- `@replit/vite-plugin-runtime-error-modal`: Error overlay in development
- `@replit/vite-plugin-cartographer` and `@replit/vite-plugin-dev-banner`: Development utilities (only loaded in non-production on Replit)