import { z } from 'zod';
import { insertContactSchema, caseStudies, services } from './schema';

// ============================================
// API CONTRACT
// ============================================
export const api = {
  work: {
    list: {
      method: 'GET' as const,
      path: '/api/work',
      responses: {
        200: z.array(z.custom<typeof caseStudies.$inferSelect>()),
      },
    },
    get: {
      method: 'GET' as const,
      path: '/api/work/:slug',
      responses: {
        200: z.custom<typeof caseStudies.$inferSelect>(),
        404: z.object({ message: z.string() }),
      },
    },
  },
  services: {
    list: {
      method: 'GET' as const,
      path: '/api/services',
      responses: {
        200: z.array(z.custom<typeof services.$inferSelect>()),
      },
    },
  },
  contact: {
    submit: {
      method: 'POST' as const,
      path: '/api/contact',
      input: insertContactSchema,
      responses: {
        201: z.object({ success: true, message: z.string() }),
        400: z.object({ message: z.string(), field: z.string().optional() }),
      },
    },
  },
};

// ============================================
// HELPER
// ============================================
export function buildUrl(path: string, params?: Record<string, string | number>): string {
  let url = path;
  if (params) {
    Object.entries(params).forEach(([key, value]) => {
      if (url.includes(`:${key}`)) {
        url = url.replace(`:${key}`, String(value));
      }
    });
  }
  return url;
}
